/*--------------------------------------
    imain.c

    Mark & Marc,  5/31/93 12:51:50
    contains the gateway calls communicating with the shell
*/

#include "icon.h"

extern EventRecordPtr fEventPtr;
extern word fUserID;
extern long remHelpID;

word			    edResFileID, shResFileID, fdResFileID;
word                isInitCurs;
handle              toolIcn[6];
handle              cursor[6];
fPrivateDataRec	    PrivPB;
fResDataRec		    DataPB;
fResNameRec		    NamePB;
fResRefRec		    RefPB;
fColorRec		    ColorPB;
fLoadFileRec	    FilePB;

word REM_OPEN(fOpenRecPtr p) {

word			retVal, retErr;
long			sizeH;
Handle		    title, ctlH;
privateDataHndl	privH;
privateDataPtr  privP;
GrafPortPtr		winP;

	if ((p->resType != rIcon) && (p->resType != rBundle))
		    return resInvalidTypeOrID;

	if (!p->resID || (p->fFlag & (F_OPENSILENT | F_OPENDATA))) {
		RefPB.resType = DataPB.resType = p->resType;
		if (p->fFlag & F_OPENDATA)
			DataPB.resData = p->Data;
		else {
			DataPB.pCount = 6;
			DataPB.resID = 10000L + p->resType;
			DataPB.resFileID = edResFileID;
			retErr = fLoadResource(&DataPB);

			RefPB.pCount = 3;
			RefPB.resID = 1L;
			RefPB.resFileID = edResFileID;
			retErr = fDetachResource(&RefPB);
		}

		DataPB.pCount = 4;
		DataPB.resID = p->resID;
		DataPB.special = 0;
		retErr = fAddResource(&DataPB);
		p->resID = DataPB.resID;

		RefPB.pCount = 2;
		RefPB.resID = DataPB.resID;
		retErr = fReleaseResource(&RefPB);

		if (p->fFlag & F_OPENSILENT)
			return 0;
	}

    privH = (privateDataHndl) NewHandle(PRIVATESIZE, fUserID, 0x0018, 0L);
    privP = *privH;

    DataPB.pCount = 5;
	DataPB.resType = rWindParam1;
	DataPB.resID = 0x00010000L + (long) p->resType;
	DataPB.special = 0;
	DataPB.resFileID = edResFileID;
	retErr = fSpecialMagic(&DataPB);
	DataPB.special = 1;
	retErr = fSpecialMagic(&DataPB);
	privP->winTempH = DataPB.resData;

    title = NewHandle(128L, fUserID, 0x8018, 0L);
	NamePB.pCount = 3;
	NamePB.resType = p->resType;
	NamePB.resID = p->resID;
	NamePB.resName = (Pointer) *title;
	retErr = fGetWindowTitle(&NamePB);
	privP->winTitle = title;

	winP = NewWindow2(*title, 0L, 0L, 0L, 1, DataPB.resData, rWindParam1);
	SetPort(winP);
	SetFrameColor(p->wColorPtr, winP);

    PrivPB.pCount = 7;
	(GrafPortPtr) PrivPB.winPtr = winP;
	PrivPB.remTaskMask = 0L;
	PrivPB.remSignature = 0;
	PrivPB.Data = (Handle) privH;
	PrivPB.groupSignature = 0x0020;
	PrivPB.resType = p->resType;
	PrivPB.resID = p->resID;
	fAddPrivateData(&PrivPB);

    DataPB.pCount = 3;
	DataPB.resType = p->resType;
	DataPB.resID = p->resID;
	retErr = fLoadResource(&DataPB);

	privP->resID = p->resID;
	privP->resData = DataPB.resData;

    switch (p->resType) {
    case rIcon:
        retErr = iconOpen(privP, winP);
        break;
    case rBundle:
        retErr = openBundle(privP, winP);
	    ShowWindow(winP);
        break;
    }
	return  0;
}

word REM_CLOSE(fCloseRecPtr p) {

word			retErr;
handle		    txtData;
long			txtLength;
GrafPortPtr		winP;
privateDataHndl	privH;
privateDataPtr  privP;

	winP = (GrafPortPtr) p->windowPtr;
	privH = getPrivate(winP);
    privP = *privH;

	checkData(winP);

	CloseWindow(winP);

	RefPB.pCount = 2;
	RefPB.resType = p->resType;
	RefPB.resID = p->resID;
	retErr = fReleaseResource(&RefPB);
	DataPB.pCount = 5;
	DataPB.resType = rWindParam1;
	DataPB.resData = privP->winTempH;
	DataPB.special = 3;
	DataPB.resFileID = edResFileID;
	retErr = fSpecialMagic(&DataPB);
	if (p->resType == rIcon) {
		DisposeHandle(privP->resData);
		DisposeHandle(privP->winTitle);
		DisposeHandle((Handle) privP->editH);
		DisposeHandle((Handle) privP->undoH);
        DisposeHandle((Handle) privP->imageCache);
        DisposeHandle((Handle) privP->maskCache);
		DisposeHandle((Handle) privH);
	}
	else {
		/* dispose of bundle handles */
	}
    InitCursor();
	return  0;
}

word REM_WRITE(fCloseRecPtr p) {

handle		    txtData;
long			txtLength;
GrafPortPtr		winP;
privateDataHndl	private;
word			retErr;

	winP = (GrafPortPtr) p->windowPtr;
	checkData(winP);
	return 0;
}

word REM_EVENT(fEventRecPtr p) {

word			retErr;
Handle		    title;
privateDataHndl	privH;
privateDataPtr  privP;
GrafPortPtr		winP, oldP;
Rect            icn, msk;
RegionHndl      theRegion;
Point           pt;
word            inImage;
word            inMask;

    oldP = GetPort();
	switch (p->taskCode) {
        case nullEvt:
	        winP = FrontWindow();
            theRegion = GetContentRgn(winP);
    	    privH = getPrivate(winP);
            privP = *privH;
            pt.h = fEventPtr->where.h;
            pt.v = fEventPtr->where.v;
            StartDrawing(winP);
            GlobalToLocal(&pt);
            inImage = PtInRect(&pt, &privP->fatIRect);
            inMask  = PtInRect(&pt, &privP->fatMRect);

            if (inImage || inMask) {
                drawCoords(privP, pt.h, pt.v, inMask);
                if (privP->tool & 0x8000) {
                    privP->tool &= 0x0007;
                    SetCursor(*cursor[privP->tool]);
                    isInitCurs = 0;
                }
            }
            else if (!isInitCurs) {
                InitCursor();
                isInitCurs = -1;
                privP->tool |= 0x8000;
            }
            break;

		case updateEvt:
			retErr = UpdateEditor((GrafPortPtr) fEventPtr->wmTaskData);
			break;

		case wInInfo:
		    retErr = InEditorInfo(fEventPtr);
			break;

		case wInContent:
            if (p->resType == rIcon)
			    FatClick(fEventPtr);
			else {
				/*   HandleBundle(fEventPtr);   */
            }
			break;

		case wInMenuBar:
            if (p->resType == rIcon)
				retErr = EditorMenu(fEventPtr);
			else
				/*  retErr = BundleMenu(fEventPtr);     */
			break;

		case app3Evt:
	        winP = (GrafPortPtr) fEventPtr->wmTaskData;
	        PrivPB.pCount = 4;
	        (GrafPortPtr) PrivPB.winPtr = winP;
	        privH = getPrivate(winP);
            privP = *privH;

			title = privP->winTitle;
			NamePB.pCount = 3;
			NamePB.resType = p->resType;
			NamePB.resID = p->resID;
			NamePB.resName = (Pointer) *title;
			retErr = fGetWindowTitle(&NamePB);
			privP->winTitle = title;
			SetWTitle(*title, winP);
			break;

		default:
			break;
	}
	return 0;
}

word REM_ACTIVATE(fActivateRecPtr p)
{
handle		    txtData;
GrafPortPtr		oldP, winP;
long			txtLength;
privateDataHndl	privH;
privateDataPtr	privP;
RegionHndl      theRegion;

	winP = (GrafPortPtr) fEventPtr->wmTaskData;
	if (p->fFlag & F_ACTIVATE) {
        privH = getPrivate(winP);
        privP = *privH;
        oldP = GetPort();
        SetPort(winP);
        MakeGlobalRect(&privP->fatIRect, &privP->gFatIRect);
        MakeGlobalRect(&privP->fatMRect, &privP->gFatMRect);
        MakeGlobalRect(&privP->sizeRect, &privP->gSizeRect);
        SetPort(oldP);

        privP->tool |= 0x8000;
        InitCursor();
        isInitCurs = -1;
		p->fFlag |= (F_CLIP + F_CLEAR + F_MENUAPPLY);
    }
	else {
		checkData(winP);
		InitCursor();
        isInitCurs = 0;

	}

	return  0;
}

word REM_GETLINK(fLinkRecPtr p) {

	return 0;		/*  The shell knows all about us...  */
}

word REM_VIDMODE(fVidModeRecPtr p) {

GrafPortPtr		winP;
privateDataHndl	privH;

	if (p->resType == rIcon) {
		(pointer) winP = p->windowPtr;
		privH = getPrivate(winP);
		SetWindowSize(*privH);
	}
	SetFrameColor(p->wColorPtr, winP);
	return 0;
}

word REM_PRINT(fCloseRecPtr p) {

	return 0;				/* no printing in this version */
}

word REM_STARTUP(fStartStopRecPtr p)
{
word    i;

	fUserID = p->edUserID;
	edResFileID = p->edResFileID;
	shResFileID = p->shResFileID;
	fdResFileID = p->fdResFileID;

    for (i = 0; i < 6; i++) {
        toolIcn[i] = loadEdRes(i + 1, rIcon);
        cursor[i] = loadEdRes(i + 1, rCursor);
    }
	return  0;
}

word REM_SHUTDOWN(fStartStopRecPtr p)
{
word    i;

    for (i = 0; i < 6; i++) {
        unloadEdRes(i + 1, rIcon);
        unloadEdRes(i + 1, rCursor);
    }
	DisposeAll(fUserID);
	return 0;
}
